#version 140
#extension GL_EXT_gpu_shader4 : enable
// Blue pistonsMod01.fsh
// https://glslsandbox.com/e#78688.0
// Licence CC0
// Adapted, trivialy, for use in VGHD player
uniform float u_Elapsed; // The time elapsed in seconds since the beginning of the scene.
uniform vec2 u_WindowSize;  // This is the dimensions of the viewport.
uniform sampler2D iChannel0;


#define iResolution u_WindowSize
#define iTime          u_Elapsed*0.31416
#define PI            3.141592654
#define iMouse AUTO_MOUSE
#define MOUSE_SPEED vec2(0.5,0.577777) * 0.2
#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
#define MOUSE_PRESS vec2(0.0,0.0)
#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
const float pi = 3.14159;

/*
 * Original shader from: https://www.shadertoy.com/view/llSGRy
 */

#ifdef GL_ES
precision highp float;
#endif

// glslsandbox uniforms
//uniform float time;
//uniform vec2 resolution;

// shadertoy emulation
//#define iTime time
//#define iResolution resolution
//const vec4 iMouse = vec4(0.);

// --------[ Original ShaderToy begins here ]---------- //
// Just for my own educational purposes...
// Extended from my previous attempt: ltSGRG
// tomkh@2015

#define SCENE 2
// Without overlap:
//   0 = centered bboxes
//   1 = centered decorated bboxes
//   2 = non-centered bboxes
//   3 = non-centered decorated
// With overlap:
//   0 = coins
//   1 = pipes
//   2 = tori

// Enable to test overlap (must be less than 0.5):
//#define OVERLAP 0.2

// Enable for cool effect
//#define TRON_MODE

const int ray_steps = 80;
const float dist_max = 20.0;
const float fog_start = 25.0;
const float fog_density = 0.05;
const float cam_dist = 30.0;

// Tile space:
const float tile_d = 2.0;
const float tile_ood = 1.0/tile_d;

// P-----+-----Q
// |     |     |
// |  A--|--B  |
// |  |p |  |  |
// +-----+-----+
// |  |  |  |  |
// |  C--|--D  |
// |     |     |
// R-----+-----S
// Say we want to find DF(p) = a distance field for "p",
// and "p" is inside ABCD boundary, where A,B,C,D are our tile centers.
// We have to assume max/min height.
// We call "frame", a bounding area of everything outside PQRS (estimated using max/min height).
// Algorithm:
//   For "p" we evaluate DF for 4 tiles: A,B,C,D
//   (possibly with early-out optimization with rough distance estimation)
//   and we bound it additionally to distance to PQRS frame.

float dist2frame(vec3 p, float box_y)
{
#ifdef OVERLAP
    vec3 dp = vec3(
        tile_d*(1.0-OVERLAP)-abs(p.x),
        max(0.0,abs(p.y)-box_y),
        tile_d*(1.0-OVERLAP)-abs(p.z));
#else
    vec3 dp = vec3(
        tile_d-abs(p.x),
        max(0.0,abs(p.y)-box_y),
        tile_d-abs(p.z));
#endif
    return length(vec2(min(dp.x,dp.z),dp.y));
}

float dist2box(vec3 p, float box_x, float box_y, float box_z, float box_r)
{
    // Distance to rounded box:
    vec3 dp = vec3(
        max(0.0,abs(p.x)-box_x),
        max(0.0,abs(p.y)-box_y),
        max(0.0,abs(p.z)-box_z));
    return length(dp) - box_r;
}

float dist2pipe(vec3 p, float r, float h, float cap)
{
    float dxz = length(p.xz) - r;
    float dy = max(0.0, abs(p.y) - h);
    return length(vec2(dxz,dy)) - cap;
}

float dist2cyl(vec3 p, float r, float h, float cap)
{
    float dxz = max(0.0, length(p.xz) - r);
    float dy = max(0.0, abs(p.y) - h);
    return length(vec2(dxz,dy)) - cap;
}

float evaluate_tile(vec3 p, vec3 p_id, float dx, float dy)
{
    p_id.xz += vec2(dx,dy);
    p.xz -= vec2(dx-.5,dy-.5)*tile_d;
    float anim = iTime*.25;
#ifdef OVERLAP
    float p1 = sin(p_id.x+anim)*sin(p_id.z+anim*.33);
    float r = tile_d*(.5 + OVERLAP);
    #if SCENE == 0
    	float dist = dist2cyl(vec3(p.x,p.y-p1*.25,p.z),r-.25,.0,.25);
    #elif SCENE == 1
    	float dist = dist2pipe(vec3(p.x,p.y-p1*2.0,p.z),r-.25,1.75,.25);
    #else
    	float dist = dist2pipe(vec3(p.x,p.y-p1*3.75,p.z),r-.25,.0,.25);
    #endif
#elif SCENE >= 2
    float p1 = 0.1 + abs(sin(p_id.x+anim)*sin(p_id.z+anim*.33))*3.9;
    float id = p_id.x + p_id.z;
    vec3 p2 = p + vec3(cos(id*3.0+anim*1.11),0,sin(id*3.0+anim*1.11))*.5;
    float dist = dist2box(p2, .25, p1, .25, 0.025);
    #if SCENE == 3
    	if (dist > .3) return dist - .1; // simple early-out optimziation
    	dist = min(dist, dist2box(p2 - vec3(0,p1*.333,0), .25, .0, .25, .1));
        dist = min(dist, dist2box(p2 - vec3(0,p1*.666,0), .25, .0, .25, .1));
    #endif
#else
    float p1 = 0.2 + abs(sin(p_id.x+anim)*sin(p_id.z+anim*.33))*3.8;
    float p2 = 0.2 + abs(cos(p_id.x+anim*.5)*cos(p_id.z+anim*.66))*.7;
    float dist = dist2box(p, p2, p1, p2, 0.025);
    #if SCENE == 1
        if (dist > .2) return dist - .1; // simple early-out optimziation
        dist = min(dist, dist2box(p, p2+.1, p1-.1, .1, 0.025));
        dist = min(dist, dist2box(p, .1, p1-.1, p2+.1, 0.025));
    #endif
#endif
    return dist;
}

float get_distance(vec3 p)
{
    vec3 p_id = vec3(
        floor(p.x*tile_ood),
        0,
        floor(p.z*tile_ood));
    
    p = vec3(
        (fract(p.x*tile_ood)-.5)*tile_d,
        p.y, //(fract(p.y*tile_ood)-.5)*tile_d,
        (fract(p.z*tile_ood)-.5)*tile_d);
    
#if defined(OVERLAP) && SCENE == 0
    float dist = dist2frame(p, .5);
#else
    float dist = dist2frame(p, 4.25);
#endif
    dist = min(dist, evaluate_tile(p, p_id, 0.0, 0.0));
    dist = min(dist, evaluate_tile(p, p_id, 1.0, 0.0));
    dist = min(dist, evaluate_tile(p, p_id, 0.0, 1.0));
    dist = min(dist, evaluate_tile(p, p_id, 1.0, 1.0));

    return dist;
}

vec3 get_normal(vec3 p)
{
    const float eps = 1e-3;
    const vec3 x_eps = vec3(eps,0,0);
    const vec3 y_eps = vec3(0,eps,0);
    const vec3 z_eps = vec3(0,0,eps);
    return normalize(vec3(
        get_distance(p + x_eps) - get_distance(p - x_eps),
        get_distance(p + y_eps) - get_distance(p - y_eps),
        get_distance(p + z_eps) - get_distance(p - z_eps) ));
}

vec3 trace(vec3 p_start, vec3 n)
{
#ifndef TRON_MODE
    float ray_len = 0.;
    float dist;
    const float dist_eps = .001;
    vec3 p = p_start;
    for(int k=0; k<ray_steps; ++k) {
    	dist = get_distance(p);
        if (dist < dist_eps || dist > dist_max) break;
        p += dist*n;
        ray_len += dist;
    }
    
    //vec3 light_dir = normalize(vec3(.1,1.0,-.3));
    float light_ang = iMouse.x/iResolution.x*3.0;
    vec3 light_dir = normalize(vec3(cos(light_ang),2.0,-sin(light_ang)));
    vec3 normal = get_normal(p);
    float shade = 0.0;
    if (dist < dist_eps) {
        //shade = (1.0 - dist/dist_eps)*dot(normal, light_dir);
        shade = dot(normal, light_dir);
        shade = max(0.0, shade);
    }
    
    vec3 base_color = vec3(1.0,1.0,1.0);
    vec3 color = mix(vec3(0.,.1,.3),vec3(1.,1.,.9),shade)*base_color;
    
    // Test ray with cut_plane:
    float cut_plane = (iMouse.y / iResolution.y - 0.1) * 8.0;
    cut_plane = max(0.0, cut_plane);
    if (p_start.y > cut_plane) {
        float d = (p_start.y - cut_plane) / -n.y;
        if (d < ray_len) {
            vec3 hit = p_start + n*d;
            float hit_dist = get_distance(hit);
            float iso = fract(hit_dist*5.0);
            vec3 dist_color = mix(vec3(.2,.4,.6),vec3(.2,.2,.4),iso);
            dist_color *= 1.0/(max(0.0,hit_dist)+.001);
            //dist_color = min(vec3(1.0,1.0,1.0),dist_color);
            color = mix(color,dist_color,.5);
            ray_len = d;
        }
    }
    vec3 fog_color = vec3(.8,.8,.8);
    float fog = 1.0-1.0/exp(max(0.0,ray_len-fog_start)*fog_density);
    color = mix(color,fog_color,fog);
#else
    vec3 color = vec3(0.,.1,.3);
   
    for(float cut_plane = 4.0; cut_plane >= 0.0; cut_plane -= 0.1) {
        // Test ray with cut_plane:
        if (p_start.y > cut_plane) {
            float d = (p_start.y - cut_plane) / -n.y;
            vec3 hit = p_start + n*d;
            float hit_dist = get_distance(hit);
            float iso = fract(hit_dist*5.0);
            vec3 dist_color = mix(vec3(.2,.4,.6),vec3(.2,.2,.4),iso);
            dist_color *= 1.0/(max(0.0,hit_dist)+.05);
            color += dist_color*.02*cut_plane*.25;
        }
    }
#endif

	return color;
}
void main( void ) 
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = (gl_FragCoord.xy - iResolution.xy*0.5) / iResolution.x;
    
    float anim = iTime*.25;
    
    float a = -0.2; //iMouse.x / iResolution.x * 2.0 - 1.0; 
    a += cos(anim)*.05;
    float co = cos(a);
    float si = sin(a);
    vec3 p1 = vec3(-cam_dist*si, 0, -cam_dist*co);
    vec3 n1 = normalize(vec3(uv,1));
    vec3 n2 = vec3(n1.x*co + n1.z*si, n1.y, -n1.x*si + n1.z*co);
    
    //a = iMouse.y / iResolution.y * 2.0 + sin(anim*(2.0/3.0))*.2 - 2.0;
    a = -.4;
    co = cos(a);
    si = sin(a);
    vec3 p2 = vec3(p1.x, p1.y*co + p1.z*si, -p1.y*si + p1.z*co);
    vec3 n3 = vec3(n2.x, n2.y*co + n2.z*si, -n2.y*si + n2.z*co);
    
    gl_FragColor = vec4(trace(p2, n3), 1.0);
    
}
// --------[ Original ShaderToy ends here ]---------- //

//void main(void)
//{//
 //   mainImage(gl_FragColor, gl_FragCoord.xy);
//}//